// This code, in its entirety, is Copyrighted Terry Smith, 2000.

import java.io.*;
import java.sql.*;
import java.util.Date;
import java.math.BigDecimal;

import Utilities;
import DBConnectionPool;

public class Member
{
   private Long m_MemberID;
   private String m_FirstName;
   private String m_LastName;
   private String m_Email;
   private boolean m_EmailBouncing;
   private String m_Password;
   private java.util.Date m_RegistrationDate;

   /** The default constructor initializes the object
   * attributes as follows:
   * <ul>
   *    <li>MemberID is a newly generated, unique ID
   *    <li>FirstName, LastName, Email, and Password are set to null.
   *    <li>EmailBouncing is set to false.
   *    <li>RegistrationDate is set to the object's creation date\time.
   * </ul>
   */
   public Member()
   {
      long Now = System.currentTimeMillis();

      m_MemberID = new Long( Now );
      m_FirstName = null;
      m_LastName = null;
      m_Email = null;
      m_EmailBouncing = false;
      m_Password = null;
      m_RegistrationDate = new java.util.Date( Now );
   }

   public Long getMemberID()
   {
      return m_MemberID;
   }

   public void setMemberID( Long MemberID )
   {
      m_MemberID = MemberID;
   }

   public String getFirstName()
   {
      return m_FirstName;
   }

   public void setFirstName( String FirstName )
   {
      m_FirstName = FirstName;
   }

   public String getLastName()
   {
      return m_LastName;
   }

   public void setLastName( String LastName )
   {
      m_LastName = LastName;
   }

   public String getEmail()
   {
      return m_Email;
   }

   public void setEmail( String Email )
   {
      m_Email = Email;
   }

   public boolean isEmailBouncing()
   {
      return m_EmailBouncing;
   }

   public void setEmailBouncing( boolean EmailBouncing )
   {
      m_EmailBouncing = EmailBouncing;
   }

   public String getPassword()
   {
      return m_Password;
   }

   public void setPassword( String Password )
   {
      m_Password = Password;
   }

   public java.util.Date getRegistrationDate()
   {
      return m_RegistrationDate;
   }

   public void setRegistrationDate( java.util.Date RegistrationDate )
   {
      m_RegistrationDate = RegistrationDate;
   }

   public String toString()
   {
      StringBuffer State = new StringBuffer();

      State.append( "\nMemberID \t\t" + m_MemberID );
      State.append( "\nFirstName \t\t" + m_FirstName );
      State.append( "\nLastName \t\t" + m_LastName );
      State.append( "\nEmail \t\t\t" + m_Email );
      State.append( "\nEmailBouncing \t\t" + m_EmailBouncing );
      State.append( "\nPassword \t\t" + m_Password );
      State.append( "\nRegistrationDate \t" + m_RegistrationDate );

      return State.toString();
   }

   public boolean create( StringBuffer ErrorMessages )
   {
      PreparedStatement Statement = null;

      DBConnectionPool dbConnectionPool = DBConnectionPool.getInstance();
      Connection dbConnection = dbConnectionPool.getConnection();

      try
      {
         StringBuffer SQL = new StringBuffer();

         SQL.append("Insert into Member (MemberID, FirstName, ");
         SQL.append("LastName, Email, EmailBouncing, Password, ");
         SQL.append("RegistrationDate) ");
         SQL.append("Values (?, ?, ?, ?, ?, ?, ?)");

         Statement = dbConnection.prepareStatement( SQL.toString() );

         if ( m_MemberID == null )
            Statement.setNull( 1, java.sql.Types.NUMERIC );
         else
            Statement.setLong( 1, m_MemberID.longValue() );

         if ( m_FirstName == null )
            Statement.setNull( 2, java.sql.Types.CHAR );
         else
            Statement.setString( 2, m_FirstName );

         if ( m_LastName == null )
            Statement.setNull( 3, java.sql.Types.CHAR );
         else
            Statement.setString( 3, m_LastName );

         if ( m_Email == null )
            Statement.setNull( 4, java.sql.Types.CHAR );
         else
            Statement.setString( 4, m_Email );

         String EmailBouncing = Utilities.booleanToString( m_EmailBouncing );
         Statement.setString( 5, EmailBouncing );

         if ( m_Password == null )
            Statement.setNull( 6, java.sql.Types.CHAR );
         else
            Statement.setString( 6, m_Password );

         if ( m_RegistrationDate == null )
         {
            Statement.setNull( 7, java.sql.Types.DATE );
         }
         else
         {
            Timestamp RegistrationDateAsTimestamp = new Timestamp( m_RegistrationDate.getTime() );
            Statement.setTimestamp( 7, RegistrationDateAsTimestamp );
         }

         int Count = Statement.executeUpdate();

         if ( Count == 1 )
         {
            dbConnection.commit();
            return true;
         }
         else
         {
            dbConnection.rollback();
            return false;
         }
      }
      catch( SQLException Exception )
      {
         String Message = Exception.getMessage();
         ErrorMessages.append( Message );
         System.out.println( Message);

         while( (Exception = Exception.getNextException()) != null )
         {
            Message = Exception.getMessage();
            ErrorMessages.append( Message );
            System.out.println( Message );
         }

         try
         {
            dbConnection.rollback();
         }
         catch( SQLException Ignored ) {}

         return false;
      }
      finally
      {
         try
         {
            if ( Statement != null )
               Statement.close();

            dbConnectionPool.free( dbConnection );
         }
         catch( Exception Ignored ) {}
      }
   }

   public boolean findByEmail( String Email )
   {
      PreparedStatement Statement = null;
      ResultSet Result = null;

      DBConnectionPool dbConnectionPool = DBConnectionPool.getInstance();
      Connection dbConnection = dbConnectionPool.getConnection();

      try
      {
         String SQL = new String( "Select * from Member where Email = ?" );
         Statement = dbConnection.prepareStatement( SQL.toString() );
         Statement.setString( 1, Email );

         Result = Statement.executeQuery();

         boolean FoundRecord = Result.next();

         if ( FoundRecord )
         {
            BigDecimal TempBigDecimal = (BigDecimal)Result.getObject( 1 );
            if ( TempBigDecimal == null )
               m_MemberID = null;
            else
               m_MemberID = new Long( TempBigDecimal.longValue() );

            m_FirstName = (String)Result.getObject( 2 );
            if ( m_FirstName != null )
               m_FirstName = m_FirstName.trim();

            m_LastName = (String)Result.getObject( 3 );
            if ( m_LastName != null )
               m_LastName = m_LastName.trim();

            m_Email = (String)Result.getObject( 4 );
            if ( m_Email != null )
               m_Email = m_Email.trim();

            String EmailBouncing = Result.getString( 5 );
            m_EmailBouncing = Utilities.stringToBoolean( EmailBouncing );

            m_Password = (String)Result.getObject( 6 );
            if ( m_Password != null )
               m_Password = m_Password.trim();

            Timestamp TempTimestamp = Result.getTimestamp( 7 );
            if ( TempTimestamp == null )
               m_RegistrationDate = null;
            else
               m_RegistrationDate = new java.util.Date( TempTimestamp.getTime() );

            return true;
         }
         else
         {
            System.out.println("Record not found.");
            return false;
         }
      }
      catch( SQLException Exception )
      {
         String Message = Exception.getMessage();
         System.out.println( Message);

         while( (Exception = Exception.getNextException()) != null )
         {
            Message = Exception.getMessage();
            System.out.println( Message );
         }

         try
         {
            dbConnection.rollback();
         }
         catch( SQLException Ignored ) {}

         return false;
      }
      finally
      {
         try
         {
            if ( Statement != null )
               Statement.close();

            if ( Result != null )
               Result.close();

            dbConnectionPool.free( dbConnection );
         }
         catch( Exception Ignored ) {}
      }
   }

   public boolean update( StringBuffer ErrorMessages )
   {
      PreparedStatement Statement = null;

      DBConnectionPool dbConnectionPool = DBConnectionPool.getInstance();
      Connection dbConnection = dbConnectionPool.getConnection();

      try
      {
         StringBuffer SQL = new StringBuffer();

         SQL.append("update Member set FirstName = ?, LastName = ?, Email = ?, ");
         SQL.append("EmailBouncing = ?, Password = ?, RegistrationDate = ? ");
         SQL.append("where MemberID = ?");

         Statement = dbConnection.prepareStatement( SQL.toString() );

         if ( m_FirstName == null )
         {
            Statement.setNull( 1, java.sql.Types.VARCHAR );
         }
         else
         {
            Statement.setString( 1, m_FirstName );
         }

         if ( m_LastName == null )
         {
            Statement.setNull( 2, java.sql.Types.VARCHAR );
         }
         else
         {
            Statement.setString( 2, m_LastName );
         }

         if ( m_Email == null )
         {
            Statement.setNull( 3, java.sql.Types.VARCHAR );
         }
         else
         {
            Statement.setString( 3, m_Email );
         }

         String EmailBouncing = Utilities.booleanToString( m_EmailBouncing );
         Statement.setString( 4, EmailBouncing );

         if ( m_Password == null )
         {
            Statement.setNull( 5, java.sql.Types.VARCHAR );
         }
         else
         {
            Statement.setString( 5, m_Password );
         }

         if ( m_RegistrationDate == null )
         {
            Statement.setNull( 6, java.sql.Types.DATE );
         }
         else
         {
            Timestamp RegistrationDateAsTimestamp = new Timestamp( m_RegistrationDate.getTime() );
            Statement.setTimestamp( 6, RegistrationDateAsTimestamp );
         }

         if ( m_MemberID == null )
         {
            Statement.setNull( 7, java.sql.Types.NUMERIC );
         }
         else
         {
            Statement.setLong( 7, m_MemberID.longValue() );
         }

         int Count = Statement.executeUpdate();

         if ( Count == 1 )
         {
            dbConnection.commit();
            return true;
         }
         else
         {
            dbConnection.rollback();
            return false;
         }
      }
      catch( SQLException Exception )
      {
         String Message = Exception.getMessage();
         ErrorMessages.append( Message );
         System.out.println( Message);

         while( (Exception = Exception.getNextException()) != null )
         {
            Message = Exception.getMessage();
            ErrorMessages.append( Message );
            System.out.println( Message );
         }

         try
         {
            dbConnection.rollback();
         }
         catch( SQLException Ignored ) {}

         return false;
      }
      finally
      {
         try
         {
            if ( Statement != null )
               Statement.close();

            dbConnectionPool.free( dbConnection );
         }
         catch( Exception Ignored ) {}
      }
   }

   public boolean delete( StringBuffer ErrorMessages )
   {
      PreparedStatement Statement = null;

      DBConnectionPool dbConnectionPool = DBConnectionPool.getInstance();
      Connection dbConnection = dbConnectionPool.getConnection();

      try
      {
         StringBuffer SQL = new StringBuffer();

         SQL.append("delete from Member where MemberID = ?");

         Statement = dbConnection.prepareStatement( SQL.toString() );

         if ( m_MemberID == null )
         {
            Statement.setNull( 1, java.sql.Types.NUMERIC );
         }
         else
         {
            Statement.setLong( 1, m_MemberID.longValue() );
         }

         int Count = Statement.executeUpdate();

         if ( Count == 1 )
         {
            dbConnection.commit();
            return true;
         }
         else
         {
            dbConnection.rollback();
            return false;
         }
      }
      catch( SQLException Exception )
      {
         String Message = Exception.getMessage();
         ErrorMessages.append( Message );
         System.out.println( Message);

         while( (Exception = Exception.getNextException()) != null )
         {
            Message = Exception.getMessage();
            ErrorMessages.append( Message );
            System.out.println( Message );
         }

         try
         {
            dbConnection.rollback();
         }
         catch( SQLException Ignored ) {}

         return false;
      }
      finally
      {
         try
         {
            if ( Statement != null )
               Statement.close();

            dbConnectionPool.free( dbConnection );
         }
         catch( Exception Ignored ) {}
      }
   }
}


